#version 330

uniform sampler1D transformMap;
uniform mat4 view;
uniform mat4 viewproj;
	
in vec4 vertex;
in vec3 normal;
//Per instance data
in vec4 uv0;//Offset and transform index
in vec4 uv1;//Scale and texture index
in vec4 colour;

out vec4 pos;
out vec3 norm;
out vec2 uv;
out vec3 idx;
out vec3 tang;
out vec3 binorm;
out vec4 vcolor;
 
void main() {
	vec4 posLocal = vec4(vertex.xyz*uv1.xyz + uv0.xyz, 1.0);
	
	int fetchBase = int(3*uv0.w);
	mat3x4 worldT;
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	
	vec4 tangent;
	
	if(abs(normal.x) > 0.5) {
		uv.xy = posLocal.yz;
		tangent = vec4(0, 1, 0, normal.x > 0 ? 1 : -1);
	} else if(abs(normal.y) > 0.5) {
		uv.xy = posLocal.xz;
		tangent = vec4(1, 0, 0, normal.y > 0 ? -1 : 1);
	} else {
		uv.xy = posLocal.xy;
		tangent = vec4(1, 0, 0, normal.z > 0 ? 1 : -1);
	}
	uv.y = -uv.y;
	
	float difIdx = uv1.w;
	float asgIdx = floor(difIdx/65536 + 0.5);
	difIdx -= asgIdx*65536;
	float norIdx = floor(difIdx/256 + 0.5);
	difIdx -= norIdx*256;
	idx = vec3(difIdx, norIdx, asgIdx);
	
	vec4 worldPos = vec4(posLocal * worldT, 1);
	vec3 worldNorm = normal * mat3(worldT);

	pos = view * worldPos;
	norm = mat3(view) * worldNorm;
	vec4 clipPos = viewproj * worldPos;

	vcolor = colour;
	
	tang = tangent.xyz * mat3(worldT);
	tang = mat3(view) * tang.xyz;
	binorm = cross(norm, tang)*tangent.w;
	
	gl_Position = clipPos;
}
